/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.js.debug.ui.internal.launchConfigurations;

import com.aptana.core.CoreStrings;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.StringUtil;
import com.aptana.debug.ui.internal.ActiveResourcePathGetterAdapter;
import com.aptana.js.debug.core.JSLaunchConfigurationHelper;
import com.aptana.js.debug.ui.JSDebugUIPlugin;
import com.aptana.js.debug.ui.internal.launchConfigurations.Messages;
import com.aptana.ui.util.UIUtils;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceComparator;

public class LaunchBrowserSettingsTab
extends AbstractLaunchConfigurationTab {
    private Listener dirtyListener;
    private Image image;
    private Text fBrowserExeText;
    private Text fCommandArgsText;
    private Button rbCurrentPage;
    private Button rbSpecificPage;
    private Button bSpecificPageBrowse;
    private Text fSpecificPageText;
    private Button rbStartUrl;
    private Text fStartUrlText;
    private Button rbInternalServer;
    private Button rbCustomServer;
    private Text fbaseUrlText;
    private Button fAddProjectName;
    private Button rbManagedServer;
    private ComboViewer managedServersView;

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        composite.setFont(parent.getFont());
        this.dirtyListener = new Listener(){

            public void handleEvent(Event event) {
                LaunchBrowserSettingsTab.this.updateEnablement();
                LaunchBrowserSettingsTab.this.setDirty(true);
                LaunchBrowserSettingsTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.createBrowserSection(composite);
        this.createStartActionSection(composite);
        this.createServerSection(composite);
        this.hookListeners(true);
    }

    private void createBrowserSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_WebBrowser);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).hint(500, -1).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 3).create());
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.LaunchBrowserSettingsTab_BrowserExecutable);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.fBrowserExeText = new Text((Composite)group, 2052);
        this.fBrowserExeText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        Button bBrowserExeBrowse = new Button((Composite)group, 8);
        bBrowserExeBrowse.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        bBrowserExeBrowse.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        label = new Label((Composite)group, 0);
        label.setText(Messages.LaunchBrowserSettingsTab_Arguments);
        label.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.fCommandArgsText = new Text((Composite)group, 2052);
        this.fCommandArgsText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        bBrowserExeBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text;
                FileDialog fileDialog = new FileDialog(LaunchBrowserSettingsTab.this.getShell(), 4096);
                fileDialog.setFileName(LaunchBrowserSettingsTab.this.fBrowserExeText.getText());
                if ("win32".equals(Platform.getOS())) {
                    fileDialog.setFilterExtensions(new String[]{"*.exe"});
                    fileDialog.setFilterNames(new String[]{Messages.LaunchBrowserSettingsTab_ExecutableFiles});
                }
                if ((text = fileDialog.open()) != null) {
                    LaunchBrowserSettingsTab.this.fBrowserExeText.setText(text);
                }
            }
        });
    }

    private void createStartActionSection(Composite parent) {
        Group group = new Group(parent, 0x800004);
        group.setText(Messages.LaunchBrowserSettingsTab_StartAction);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).create());
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 3).create());
        this.rbCurrentPage = new Button((Composite)group, 16);
        this.rbCurrentPage.setText(Messages.LaunchBrowserSettingsTab_UseCurrentPage);
        this.rbCurrentPage.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).span(3, 1).grab(true, false).create());
        this.rbSpecificPage = new Button((Composite)group, 16);
        this.rbSpecificPage.setText(Messages.LaunchBrowserSettingsTab_SpecificPage);
        this.rbSpecificPage.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.fSpecificPageText = new Text((Composite)group, 2052);
        this.fSpecificPageText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.bSpecificPageBrowse = new Button((Composite)group, 8);
        this.bSpecificPageBrowse.setText(StringUtil.ellipsify((String)CoreStrings.BROWSE));
        this.bSpecificPageBrowse.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.rbStartUrl = new Button((Composite)group, 16);
        this.rbStartUrl.setText(Messages.LaunchBrowserSettingsTab_StartURL);
        this.rbStartUrl.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        this.fStartUrlText = new Text((Composite)group, 2052);
        this.fStartUrlText.setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).span(2, 1).grab(true, false).create());
        this.bSpecificPageBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IResource resource = LaunchBrowserSettingsTab.this.chooseWorkspaceLocation();
                if (resource != null) {
                    LaunchBrowserSettingsTab.this.fSpecificPageText.setText(resource.getFullPath().toPortableString());
                }
            }
        });
    }

    private void createServerSection(Composite parent) {
        Group group = new Group(parent, 0x800000);
        group.setText(Messages.LaunchBrowserSettingsTab_Server);
        group.setFont(parent.getFont());
        group.setLayoutData((Object)new GridData(4, 4, true, false));
        group.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(3).margins(10, 3).create());
        this.rbInternalServer = new Button((Composite)group, 16);
        this.rbInternalServer.setText(Messages.LaunchBrowserSettingsTab_UseBuiltInWebServer);
        this.rbInternalServer.setLayoutData((Object)GridDataFactory.fillDefaults().span(3, 1).create());
        this.rbManagedServer = new Button((Composite)group, 16);
        this.rbManagedServer.setText(Messages.LaunchBrowserSettingsTab_Use_Selected_Server);
        this.rbManagedServer.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.managedServersView = new ComboViewer((Composite)group, 12);
        this.managedServersView.getControl().setLayoutData((Object)GridDataFactory.swtDefaults().align(4, 0x1000000).grab(true, false).create());
        this.managedServersView.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.managedServersView.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IServer) {
                    return ((IServer)element).getName();
                }
                return super.getText(element);
            }
        });
        this.managedServersView.setInput((Object)WebServerCorePlugin.getDefault().getServerManager().getServers());
        Link configureLink = new Link((Composite)group, 0);
        configureLink.setText(MessageFormat.format("<a>{0}</a>", Messages.LaunchBrowserSettingsTab_Configure_Label));
        configureLink.setLayoutData((Object)GridDataFactory.swtDefaults().create());
        configureLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dlg = PreferencesUtil.createPreferenceDialogOn((Shell)UIUtils.getActiveShell(), (String)"com.aptana.webserver.preferences.servers", (String[])new String[]{"com.aptana.webserver.preferences.servers"}, null, (int)1);
                dlg.open();
                ISelection selection = LaunchBrowserSettingsTab.this.managedServersView.getSelection();
                LaunchBrowserSettingsTab.this.managedServersView.setInput((Object)WebServerCorePlugin.getDefault().getServerManager().getServers());
                LaunchBrowserSettingsTab.this.managedServersView.setSelection(selection);
            }
        });
        this.rbCustomServer = new Button((Composite)group, 16);
        this.rbCustomServer.setText(Messages.LaunchBrowserSettingsTab_UseExternalWebServer);
        this.rbCustomServer.setLayoutData((Object)GridDataFactory.fillDefaults().create());
        this.fbaseUrlText = new Text((Composite)group, 2052);
        this.fbaseUrlText.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).grab(true, false).create());
        this.fAddProjectName = new Button((Composite)group, 32);
        this.fAddProjectName.setText(Messages.LaunchBrowserSettingsTab_AppendProjectName);
        this.fAddProjectName.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, false).span(3, 1).create());
    }

    private void hookListeners(boolean hook) {
        if (hook) {
            this.fBrowserExeText.addListener(24, this.dirtyListener);
            this.fCommandArgsText.addListener(24, this.dirtyListener);
            this.fSpecificPageText.addListener(24, this.dirtyListener);
            this.fStartUrlText.addListener(24, this.dirtyListener);
            this.rbCurrentPage.addListener(13, this.dirtyListener);
            this.rbSpecificPage.addListener(13, this.dirtyListener);
            this.rbStartUrl.addListener(13, this.dirtyListener);
            this.fbaseUrlText.addListener(24, this.dirtyListener);
            this.rbInternalServer.addListener(13, this.dirtyListener);
            this.rbCustomServer.addListener(13, this.dirtyListener);
            this.rbManagedServer.addListener(13, this.dirtyListener);
            this.managedServersView.getControl().addListener(13, this.dirtyListener);
            this.fAddProjectName.addListener(13, this.dirtyListener);
        } else {
            this.fBrowserExeText.removeListener(24, this.dirtyListener);
            this.fCommandArgsText.removeListener(24, this.dirtyListener);
            this.fSpecificPageText.removeListener(24, this.dirtyListener);
            this.fStartUrlText.removeListener(24, this.dirtyListener);
            this.rbCurrentPage.removeListener(13, this.dirtyListener);
            this.rbSpecificPage.removeListener(13, this.dirtyListener);
            this.rbStartUrl.removeListener(13, this.dirtyListener);
            this.fbaseUrlText.removeListener(24, this.dirtyListener);
            this.rbInternalServer.removeListener(13, this.dirtyListener);
            this.rbCustomServer.removeListener(13, this.dirtyListener);
            this.rbManagedServer.removeListener(13, this.dirtyListener);
            this.managedServersView.getControl().removeListener(13, this.dirtyListener);
            this.fAddProjectName.addListener(13, this.dirtyListener);
        }
    }

    private void updateEnablement() {
        this.fSpecificPageText.setEnabled(this.rbSpecificPage.getSelection());
        this.bSpecificPageBrowse.setEnabled(this.rbSpecificPage.getSelection());
        boolean startUrlEnabled = this.rbStartUrl.getSelection();
        this.fStartUrlText.setEnabled(startUrlEnabled);
        this.fbaseUrlText.setEnabled(!startUrlEnabled && this.rbCustomServer.getSelection());
        this.managedServersView.getControl().setEnabled(!startUrlEnabled && this.rbManagedServer.getSelection());
        this.managedServersView.getControl().setForeground(this.getShell().getDisplay().getSystemColor(!startUrlEnabled && this.rbManagedServer.getSelection() ? 24 : 33));
        this.rbInternalServer.setEnabled(!startUrlEnabled);
        this.rbManagedServer.setEnabled(!startUrlEnabled);
        this.rbCustomServer.setEnabled(!startUrlEnabled);
        this.fAddProjectName.setEnabled(this.rbCustomServer.getSelection() && (this.rbCurrentPage.getSelection() || this.rbSpecificPage.getSelection()));
    }

    private IResource chooseWorkspaceLocation() {
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
        dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        dialog.setComparator((ViewerComparator)new ResourceComparator(1));
        dialog.setMessage(Messages.LaunchBrowserSettingsTab_ChooseFile);
        if (dialog.open() == 0) {
            return (IResource)dialog.getFirstResult();
        }
        return null;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        JSLaunchConfigurationHelper.setBrowserDefaults((ILaunchConfigurationWorkingCopy)configuration, null);
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.hookListeners(false);
        try {
            try {
                this.fBrowserExeText.setText(configuration.getAttribute("browserExecutable", ""));
                this.fCommandArgsText.setText(configuration.getAttribute("browserCmdLine", ""));
                int startActionType = configuration.getAttribute("startActionType", 1);
                this.rbCurrentPage.setSelection(startActionType == 1);
                this.rbSpecificPage.setSelection(startActionType == 2);
                this.fSpecificPageText.setText(configuration.getAttribute("startPagePath", ""));
                this.rbStartUrl.setSelection(startActionType == 3);
                this.fStartUrlText.setText(configuration.getAttribute("startPageUrl", ""));
                this.fAddProjectName.setSelection(configuration.getAttribute("appendProjectName", false));
                int serverType = configuration.getAttribute("serverType", 1);
                this.rbInternalServer.setSelection(serverType == 1);
                this.rbCustomServer.setSelection(serverType == 3);
                this.fbaseUrlText.setText(configuration.getAttribute("externalBaseUrl", ""));
                this.rbManagedServer.setSelection(serverType == 2);
                IServer server = WebServerCorePlugin.getDefault().getServerManager().findServerByName(configuration.getAttribute("serverName", ""));
                if (server != null) {
                    this.managedServersView.setSelection((ISelection)new StructuredSelection((Object)server));
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)JSDebugUIPlugin.getDefault(), (String)"Reading launch configuration fails", (Throwable)e);
                this.hookListeners(true);
                this.updateEnablement();
            }
        }
        finally {
            this.hookListeners(true);
            this.updateEnablement();
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String value = this.fBrowserExeText.getText();
        configuration.setAttribute("browserExecutable", value);
        value = this.fCommandArgsText.getText();
        configuration.setAttribute("browserCmdLine", value);
        int startActionType = 0;
        if (this.rbCurrentPage.getSelection()) {
            startActionType = 1;
        } else if (this.rbSpecificPage.getSelection()) {
            startActionType = 2;
        } else if (this.rbStartUrl.getSelection()) {
            startActionType = 3;
        }
        configuration.setAttribute("startActionType", startActionType);
        value = this.fSpecificPageText.getText();
        configuration.setAttribute("startPagePath", value);
        value = this.fStartUrlText.getText();
        configuration.setAttribute("startPageUrl", value);
        int serverType = 0;
        if (this.rbInternalServer.getSelection()) {
            serverType = 1;
        } else if (this.rbCustomServer.getSelection()) {
            serverType = 3;
        } else if (this.rbManagedServer.getSelection()) {
            serverType = 2;
        }
        configuration.setAttribute("serverType", serverType);
        value = this.fbaseUrlText.getText();
        configuration.setAttribute("externalBaseUrl", value);
        IServer serverSelection = (IServer)((IStructuredSelection)this.managedServersView.getSelection()).getFirstElement();
        configuration.setAttribute("serverName", serverSelection != null ? serverSelection.getName() : null);
        configuration.setAttribute("appendProjectName", this.fAddProjectName.getSelection());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        IServer serverSelection;
        IPath activeResource;
        this.setErrorMessage(null);
        this.setMessage(null);
        String value = this.fBrowserExeText.getText();
        if (!new File(value).exists()) {
            this.setErrorMessage(Messages.LaunchBrowserSettingsTab_BrowserExecutableShouldBeSpecified);
            return false;
        }
        if (this.rbSpecificPage.getSelection()) {
            value = this.fSpecificPageText.getText();
            if (value.length() == 0 || ResourcesPlugin.getWorkspace().getRoot().findMember(value) == null) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_StartPageShouldBeSpecified);
                return false;
            }
        } else if (this.rbStartUrl.getSelection()) {
            value = this.fStartUrlText.getText();
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_ValidStartPageURLShouldBeSpecified);
                return false;
            }
        }
        if (this.rbCustomServer.getSelection()) {
            value = this.fbaseUrlText.getText();
            try {
                new URL(value);
            }
            catch (MalformedURLException e) {
                this.setErrorMessage(Messages.LaunchBrowserSettingsTab_ValidBaseURLShouldBeSpecified);
                return false;
            }
        }
        if (this.rbCurrentPage.getSelection() && (activeResource = new ActiveResourcePathGetterAdapter().getActiveResourcePath()) == null) {
            this.setMessage(Messages.LaunchBrowserSettingsTab_NoFilesOpenedInEditor);
            return false;
        }
        if (this.rbManagedServer.getSelection() && (serverSelection = (IServer)((IStructuredSelection)this.managedServersView.getSelection()).getFirstElement()) == null) {
            this.setErrorMessage(Messages.LaunchBrowserSettingsTab_ServerNotSelected);
            return false;
        }
        return true;
    }

    public String getName() {
        return Messages.LaunchBrowserSettingsTab_Main;
    }

    public Image getImage() {
        if (this.image == null) {
            this.image = JSDebugUIPlugin.getImageDescriptor("icons/full/obj16/launch-main.gif").createImage();
        }
        return this.image;
    }

    public void dispose() {
        if (this.image != null) {
            this.image.dispose();
        }
        super.dispose();
    }
}

